﻿<%@ Control Language="C#" AutoEventWireup="true" CodeFile="ucInstrumentSelection.ascx.cs" Inherits="ucInstrumentSelection" %>
<script language="javascript" type="text/javascript">
</script>
 
<ext:Window ID="wndAddInstrument" Title="Edit Pathway" Hidden="true"
        Layout="AnchorLayout" Height="515" Width="720"
         IDMode="Static" runat="server" 
        Constrain="true"
    
        Modal="true"
        Collapsible="false"
        Resizable="false"
        Maximizable="false"
        Draggable="false" 
        XOnEsc="Ext.emptyFn">
    <Listeners>
        <BeforeShow Handler="App.pnlMMenu.mask();App.vpMasterViewport.mask();"></BeforeShow>
        <Hide Handler="App.pnlMMenu.unmask();App.vpMasterViewport.unmask();" />
        <Close Handler="App.pnlMMenu.unmask();App.vpMasterViewport.unmask();" />
    </Listeners>
        <Items>

            <ext:Panel Border="false" Layout="ColumnLayout" runat="server" Padding="3" Width="850">
            <Items>
            
            <ext:TextField FieldLabel="Title" LabelWidth="40" AutoDataBind="true"
                Padding="3" ID="tfEPWEventTitle" ReadOnly="false"  Width="300" runat="server">
            </ext:TextField>

            <ext:DateField ID="dfEPWEventDate"
                           runat="server"
                           AllowBlank="false"
                           FieldLabel="Date" LabelWidth="40"
                           AutoDataBind="true"
                           Width="180"
                           Padding="3">
            </ext:DateField>

            <ext:Checkbox ID="chkEPWAdjustFuture"
                           runat="server"
                           BoxLabel="Adjust Future Dates?"
                           HideEmptyLabel="true">
            </ext:Checkbox>

            </Items>
            </ext:Panel>

            <ext:FormPanel
                ID="containerAddInstrument"
                Margin="3"
                Border="false"
                Layout="AnchorLayout"
                runat="server">
                <Items>

                    <ext:RadioGroup
                        ID="rgInstrumentGroupType"
                        runat="server"
                        Vertical="true"
                        AnchorHorizontal="70%"
                        FieldLabel="Filter by"
                        LabelWidth="50" 
                         Padding="3">
                        <Items>
                        </Items>
                        <Listeners>
                            <Change Handler="App.direct.UCINSTRUMENTSEL.OnGroupTypeSelect(this.getValue());" />
                        </Listeners>
                    </ext:RadioGroup>

                    <ext:ComboBox
                        ID="cboInstrumentGroup"
                        runat="server"
                        Editable="false"
                        ValueField="MODULE_GROUP_ID"
                        DisplayField="MODULE_GROUP_DESCR"
                        AnchorHorizontal="99%"
                         FieldLabel="Choose Filter"
                        LabelWidth="80" 
                         Padding="3">
                        <Store>
                            <ext:Store ID="storModuleGroups" AutoLoad="true" runat="server">
                                <Model>
                                    <ext:Model ID="mdlGroupTypes" runat="Server" IDProperty="MODULE_GROUP_ID">
                                        <Fields>
                                            <ext:ModelField Name="MODULE_GROUP_ID" />
                                            <ext:ModelField Name="MODULE_GROUP_DESCR" />
                                        </Fields>
                                    </ext:Model>
                                </Model>
                                <Reader>
                                    <ext:JsonReader RootProperty="Tables[0].Rows">
                                    </ext:JsonReader>
                                </Reader>
                            </ext:Store>
                        </Store>
                        <Listeners>
                            <Select Handler="App.direct.UCINSTRUMENTSEL.OnGroupSelect();" />
                        </Listeners>
                    </ext:ComboBox>
                                       
                    <ext:GridPanel
                        ID="gpInstruments"
                        runat="server"
                        AnchorHorizontal="99%" 
                        MinHeight="160"
                        Height="160"
                        Padding="3" 
                        Title="Filtered Instruments">
                        <Listeners>
                        </Listeners>
                        <SelectionModel>
                            <ext:CheckboxSelectionModel ID="smInstruments" runat="server" Mode="Simple" >
                                <Listeners>
                                    <Select Handler="App.direct.UCINSTRUMENTSEL.OnInstrumentSel( Ext.encode(record.data) );" />
                                    <Deselect Handler="App.direct.UCINSTRUMENTSEL.OnInstrumentDeSel (Ext.encode(record.data) );" />
                                </Listeners>
                            </ext:CheckboxSelectionModel>
                        </SelectionModel>
                        <ColumnModel ID="cmdlInstruments" runat="server">
                            <Columns>
                                <ext:Column runat="server"
                                    DataIndex="MODULE" Text="Instrument Name"
                                    Flex="48" >
                                        <Renderer Handler="return Ext.util.Format.htmlDecode(value);" />
                                    </ext:Column>
                                <ext:Column runat="server"
                                    DataIndex="DESCRIPTION" Text="Description"
                                    Flex="48" >
                                        <Renderer Handler="return Ext.util.Format.htmlDecode(value);" />
                                    </ext:Column>
                            </Columns>
                        </ColumnModel>
                        <Store>
                            <ext:Store
                                ID="storInstruments"
                                AutoLoad="true"
                                runat="server">
                                <Model>
                                    <ext:Model ID="mdlInstruments" runat="Server" IDProperty="MID">
                                        <Fields>
                                            <ext:ModelField Name="MID" />
                                            
                                            <ext:ModelField Name="MODULE" >
                                                
                                            </ext:ModelField>
                                            
                                            <ext:ModelField Name="MODULE_FOR" />

                                            <ext:ModelField Name="DESCRIPTION" >
                                 
                                            </ext:ModelField>
                                            
                                        </Fields>
                                    </ext:Model>
                                </Model>
                                <Reader>
                                    <ext:JsonReader RootProperty="Tables[0].Rows">
                                    </ext:JsonReader>
                                </Reader>
                            </ext:Store>
                        </Store>
                    </ext:GridPanel>

                    <ext:GridPanel
                        ID="gpSelInstruments"
                        runat="server"
                        AnchorHorizontal="99%"
                        MinHeight="180"
                        Height="190"
                        Padding="3" 
                        Title="Selected Instruments">
                        <SelectionModel>
                            <ext:RowSelectionModel  ID="smSelInstruments" runat="server" Mode="Single" />
                        </SelectionModel>
                        <ColumnModel ID="cmdlSelInstruments" runat="server">
                            <Columns>
                                <ext:Column runat="server"
                                    DataIndex="MODULE" Text="Instrument Name"
                                    Flex="45" >
                                    <Renderer Handler="return Ext.util.Format.htmlDecode(value);" />
                                    </ext:Column>
                                <ext:Column runat="server"
                                    DataIndex="DESCRIPTION" Text="Description"
                                    Flex="43" >
                                    <Renderer Handler="return Ext.util.Format.htmlDecode(value);" />
                                    </ext:Column>
                                <ext:ComponentColumn ID="ucselModuleFor" 
                                    runat="server" 
                                    Editor="true"
                                    DataIndex="MODULE_FOR"
                                    Flex="12"
                                    Text="For">
                                    <Component>
                                        <ext:ComboBox runat="server" Editable="false">
                                            <Items>
                                                <ext:ListItem Text="Patient" Value="1" Mode="Raw" />
                                                <ext:ListItem Text="Provider" Value="2" Mode="Raw" />
                                                <ext:ListItem Text="Both" Value="3" Mode="Raw" />
                                            </Items>
                                        </ext:ComboBox>
                                    </Component>
                                </ext:ComponentColumn>
                            </Columns>
                        </ColumnModel>
                        <Store>
                            <ext:Store
                                ID="storSelInstruments"
                                AutoLoad="true"
                                runat="server">
                                <Model>
                                    <ext:Model ID="mdlSelInstruments" runat="Server" IDProperty="MID">
                                        <Fields>
                                            <ext:ModelField Name="MID" />
                                            <ext:ModelField Name="MODULE" >
                                                
                                            </ext:ModelField>
                                            <ext:ModelField Name="MODULE_FOR" />
                                            <ext:ModelField Name="DESCRIPTION" >
                                              
                                            </ext:ModelField>
                                        </Fields>
                                    </ext:Model>
                                </Model>
                                <Reader>
                                    <ext:JsonReader RootProperty="Tables[0].Rows">
                                    </ext:JsonReader>
                                </Reader>
                            </ext:Store>
                        </Store>
                        <BottomBar>
                        <ext:Toolbar runat="server">
                            <Items>
                                <ext:Button ID="btnRemoveSelInstrument" runat="server" Text="Remove" Icon="Delete" Handler="App.direct.UCINSTRUMENTSEL.OnRemoveInstrument();" >
                                <Listeners>

                                </Listeners>
                                </ext:Button>
                            </Items>
                        </ext:Toolbar>
                        </BottomBar>
                    </ext:GridPanel>

                </Items>
            </ext:FormPanel>

        </Items>
        <BottomBar>
            <ext:Toolbar ID="tbInstrumentSelection" runat="server">
                <Items>

                    <ext:Button ID="btnInsSelOK" runat="server" Text="OK" Icon="Disk">
                    <Listeners>

                    </Listeners>
                    <DirectEvents>
                    <Click OnEvent="OnInstrSelOK" Success="App.direct.UCINSTRUMENTSEL.ReloadPWEventNodes()">
                    <ExtraParams>
                        <ext:Parameter Name="gpSelParam" Value="Ext.util.Format.htmlEncode( Ext.encode(#{gpSelInstruments}.getRowsValues({selectedOnly : false})) )" Mode="Raw" />
                    </ExtraParams>
                    </Click>
                    </DirectEvents>
                    </ext:Button>

                    <ext:Button ID="btnInsSelCancel" runat="server" Text="Cancel" Icon="Cancel" Handler="App.direct.UCINSTRUMENTSEL.OnInstrumentSelCancel()" >
                    <Listeners>

                    </Listeners>
                    </ext:Button>

                </Items>
            </ext:Toolbar>
        </BottomBar>
    </ext:Window>